/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ElephantToken;

class TerastodonEffect
extends OneShotEffect {
    TerastodonEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "you may destroy up to three target noncreature permanents. For each permanent put into a graveyard this way, its controller creates a 3/3 green Elephant creature token";
    }

    private TerastodonEffect(TerastodonEffect effect) {
        super((OneShotEffect)effect);
    }

    public TerastodonEffect copy() {
        return new TerastodonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<UUID, Integer> destroyedPermanents = new HashMap<UUID, Integer>();
        for (UUID targetID : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetID);
            if (permanent == null || !permanent.destroy(source, game, false) || game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD) continue;
            int numberPermanents = destroyedPermanents.getOrDefault(permanent.getControllerId(), 0);
            destroyedPermanents.put(permanent.getControllerId(), numberPermanents + 1);
        }
        game.processAction();
        ElephantToken elephantToken = new ElephantToken();
        for (Map.Entry entry : destroyedPermanents.entrySet()) {
            elephantToken.putOntoBattlefield(((Integer)entry.getValue()).intValue(), game, source, (UUID)entry.getKey());
        }
        return true;
    }
}

