/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TerminalVelocityDamageEffect
extends OneShotEffect {
    TerminalVelocityDamageEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals damage equal to its mana value to each creature";
    }

    private TerminalVelocityDamageEffect(TerminalVelocityDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public TerminalVelocityDamageEffect copy() {
        return new TerminalVelocityDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null || permanent.getManaValue() < 1) {
            return false;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            creature.damage(permanent.getManaValue(), permanent.getId(), source, game);
        }
        return true;
    }
}

