/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.Card;
import mage.cards.t.TerminalVelocityDamageEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class TerminalVelocityEffect
extends OneShotEffect {
    TerminalVelocityEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put an artifact or creature card from your hand onto the battlefield. That permanent gains haste, \"When this permanent leaves the battlefield, it deals damage equal to its mana value to each creature,\" and \"At the beginning of your end step, sacrifice this permanent.\"";
    }

    private TerminalVelocityEffect(TerminalVelocityEffect effect) {
        super((OneShotEffect)effect);
    }

    public TerminalVelocityEffect copy() {
        return new TerminalVelocityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, StaticFilters.FILTER_CARD_ARTIFACT_OR_CREATURE);
        player.choose(Outcome.PutCardInPlay, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return true;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.addEffect(new GainAbilityTargetEffect((Ability)new LeavesBattlefieldTriggeredAbility((Effect)new TerminalVelocityDamageEffect()).setTriggerPhrase("When this permanent leaves the battlefield, "), Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.addEffect(new GainAbilityTargetEffect((Ability)new BeginningOfEndStepTriggeredAbility((Effect)new SacrificeSourceEffect().setText("sacrifice this permanent")), Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

