/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TerraformerContinuousEffect
extends ContinuousEffectImpl {
    TerraformerContinuousEffect() {
        super(Duration.EndOfTurn, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
    }

    private TerraformerContinuousEffect(TerraformerContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TerraformerContinuousEffect copy() {
        return new TerraformerContinuousEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        SubType choice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "_Terraformer")));
        if (choice == null) {
            this.discard();
            return;
        }
        switch (choice) {
            case FOREST: {
                this.dependencyTypes.add(DependencyType.BecomeForest);
                break;
            }
            case PLAINS: {
                this.dependencyTypes.add(DependencyType.BecomePlains);
                break;
            }
            case MOUNTAIN: {
                this.dependencyTypes.add(DependencyType.BecomeMountain);
                break;
            }
            case ISLAND: {
                this.dependencyTypes.add(DependencyType.BecomeIsland);
                break;
            }
            case SWAMP: {
                this.dependencyTypes.add(DependencyType.BecomeSwamp);
            }
        }
        if (this.getAffectedObjectsSet()) {
            game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getControllerId(), source, game).stream().map(permanent -> new MageObjectReference((MageObject)permanent, game)).forEach(this.affectedObjectList::add);
        }
    }

    public boolean apply(Game game, Ability source) {
        SubType choice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "_Terraformer")));
        if (choice == null) {
            return false;
        }
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent land = ((MageObjectReference)it.next()).getPermanent(game);
            if (land == null) {
                it.remove();
                continue;
            }
            land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
            land.addSubType(game, new SubType[]{choice});
            land.removeAllAbilities(source.getSourceId(), game);
            switch (choice) {
                case FOREST: {
                    land.addAbility((Ability)new GreenManaAbility(), source.getSourceId(), game);
                    break;
                }
                case PLAINS: {
                    land.addAbility((Ability)new WhiteManaAbility(), source.getSourceId(), game);
                    break;
                }
                case MOUNTAIN: {
                    land.addAbility((Ability)new RedManaAbility(), source.getSourceId(), game);
                    break;
                }
                case ISLAND: {
                    land.addAbility((Ability)new BlueManaAbility(), source.getSourceId(), game);
                    break;
                }
                case SWAMP: {
                    land.addAbility((Ability)new BlackManaAbility(), source.getSourceId(), game);
                }
            }
        }
        return true;
    }
}

