/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.t.TerritorialBruntarAsThoughEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TerritorialBruntarEffect
extends OneShotEffect {
    TerritorialBruntarEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards from the top of your library until you exile a nonland card. You may cast that card this turn";
    }

    private TerritorialBruntarEffect(TerritorialBruntarEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean didSomething = false;
        for (Card card : controller.getLibrary().getCards(game)) {
            didSomething |= controller.moveCards(card, Zone.EXILED, source, game);
            if (game.getState().getZone(card.getId()) != Zone.EXILED || card.isLand(game)) continue;
            TerritorialBruntarAsThoughEffect effect = new TerritorialBruntarAsThoughEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return didSomething;
    }

    public TerritorialBruntarEffect copy() {
        return new TerritorialBruntarEffect(this);
    }
}

