/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TezzeretAgentOfBolasEffect2
extends OneShotEffect {
    public TezzeretAgentOfBolasEffect2() {
        super(Outcome.DrawCard);
        this.staticText = "Target player loses X life and you gain X life, where X is twice the number of artifacts you control";
    }

    private TezzeretAgentOfBolasEffect2(TezzeretAgentOfBolasEffect2 effect) {
        super((OneShotEffect)effect);
    }

    public TezzeretAgentOfBolasEffect2 copy() {
        return new TezzeretAgentOfBolasEffect2(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = new PermanentsOnBattlefieldCount((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT).calculate(game, source, (Effect)this) * 2;
        if (count > 0) {
            Player controller;
            Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (targetPlayer != null) {
                targetPlayer.loseLife(count, game, source, false);
            }
            if ((controller = game.getPlayer(source.getControllerId())) != null) {
                controller.gainLife(count, game, source);
            }
        }
        return true;
    }
}

