/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class TezzeretBetrayerOfFleshWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    TezzeretBetrayerOfFleshWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ACTIVATED_ABILITY) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent != null && permanent.isArtifact(game)) {
            this.playerSet.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    public static boolean checkPlayer(Game game, Ability ability) {
        if (((TezzeretBetrayerOfFleshWatcher)game.getState().getWatcher(TezzeretBetrayerOfFleshWatcher.class)).playerSet.contains(ability.getControllerId())) {
            return false;
        }
        Permanent permanent = ability.getSourcePermanentOrLKI(game);
        return permanent != null && permanent.isArtifact(game);
    }
}

