/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TezzeretCruelMachinistCardTypeEffect
extends ContinuousEffectImpl {
    TezzeretCruelMachinistCardTypeEffect() {
        super(Duration.Custom, Layer.CopyEffects_1, SubLayer.FaceDownEffects_1b, Outcome.Neutral);
    }

    private TezzeretCruelMachinistCardTypeEffect(TezzeretCruelMachinistCardTypeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TezzeretCruelMachinistCardTypeEffect copy() {
        return new TezzeretCruelMachinistCardTypeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean flag = false;
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent target = game.getPermanent(targetId);
            if (target == null || !target.isFaceDown(game)) continue;
            flag = true;
            target.removeAllSuperTypes(game);
            target.removeAllCardTypes(game);
            target.removeAllSubTypes(game);
            target.addCardType(game, new CardType[]{CardType.ARTIFACT, CardType.CREATURE});
            target.getPower().setModifiedBaseValue(5);
            target.getToughness().setModifiedBaseValue(5);
        }
        if (!flag) {
            this.discard();
            return false;
        }
        return true;
    }
}

