/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TezzeretTheSeekerEffect3
extends ContinuousEffectImpl {
    public TezzeretTheSeekerEffect3() {
        super(Duration.EndOfTurn, Outcome.BecomeCreature);
        this.staticText = "Artifacts you control become artifact creatures with base power and toughness 5/5 until end of turn";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private TezzeretTheSeekerEffect3(TezzeretTheSeekerEffect3 effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TezzeretTheSeekerEffect3 copy() {
        return new TezzeretTheSeekerEffect3(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        List permanents = game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterArtifactPermanent(), source.getControllerId(), game);
        for (Permanent permanent : permanents) {
            if (permanent == null) continue;
            switch (layer) {
                case TypeChangingEffects_4: {
                    if (sublayer != SubLayer.NA) break;
                    if (!permanent.isArtifact(game)) {
                        permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
                    }
                    if (permanent.isCreature(game)) break;
                    permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(5);
                    permanent.getToughness().setModifiedBaseValue(5);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.PTChangingEffects_7;
    }
}

