/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class ThadaAdelAcquisitorEffect
extends OneShotEffect {
    ThadaAdelAcquisitorEffect() {
        super(Outcome.Exile);
        this.staticText = "search that player's library for an artifact card and exile it. Then that player shuffles. Until end of turn, you may play that card";
    }

    private ThadaAdelAcquisitorEffect(ThadaAdelAcquisitorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player damagedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || damagedPlayer == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT);
        controller.searchLibrary(target, source, game, damagedPlayer.getId());
        Card card = damagedPlayer.getLibrary().getCard(target.getFirstTarget(), game);
        PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Card)card, (TargetController)TargetController.YOU, (Duration)Duration.EndOfTurn, (boolean)false, (boolean)false, (boolean)false);
        damagedPlayer.shuffleLibrary(source, game);
        return true;
    }

    public ThadaAdelAcquisitorEffect copy() {
        return new ThadaAdelAcquisitorEffect(this);
    }
}

