/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class ThaumatonTorpedoWatcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    ThaumatonTorpedoWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ATTACKER_DECLARED) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent != null && permanent.hasSubtype(SubType.SPACECRAFT, game)) {
            this.set.add(permanent.getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((ThaumatonTorpedoWatcher)game.getState().getWatcher(ThaumatonTorpedoWatcher.class)).set.contains(source.getControllerId());
    }
}

