/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.util.CardUtil;

class TheAesirEscapeValhallaOneEffect
extends OneShotEffect {
    TheAesirEscapeValhallaOneEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile a permanent card from your graveyard. You gain life equal to its mana value.";
    }

    private TheAesirEscapeValhallaOneEffect(TheAesirEscapeValhallaOneEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheAesirEscapeValhallaOneEffect copy() {
        return new TheAesirEscapeValhallaOneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_PERMANENT);
        controller.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source, (int)1);
            MageObject sourceObject = source.getSourceObject(game);
            String exileName = sourceObject != null ? sourceObject.getName() : "";
            controller.moveCardsToExile(card, source, game, false, exileId, exileName);
            controller.gainLife(card.getManaValue(), game, source);
        }
        return true;
    }
}

