/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;

class TheAkroanWarEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent();

    TheAkroanWarEffect() {
        super(Outcome.Benefit);
        this.staticText = "each tapped creature deals damage to itself equal to its power";
    }

    private TheAkroanWarEffect(TheAkroanWarEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheAkroanWarEffect copy() {
        return new TheAkroanWarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game).stream().forEach(permanent -> permanent.damage(permanent.getPower().getValue(), permanent.getId(), source, game));
        return true;
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
    }
}

