/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.RollDieType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.RollDieEvent;

class TheBigIdeaReplacementEffect
extends ReplacementEffectImpl {
    TheBigIdeaReplacementEffect() {
        super(Duration.OneUse, Outcome.Damage);
        this.staticText = "The next time you would roll a six-sided die, instead roll two six-sided dice and use the total of those results";
    }

    private TheBigIdeaReplacementEffect(TheBigIdeaReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TheBigIdeaReplacementEffect copy() {
        return new TheBigIdeaReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((RollDieEvent)event).incBigIdeaRollsAmount();
        this.discard();
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ROLL_DIE && ((RollDieEvent)event).getRollDieType() == RollDieType.NUMERICAL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return !this.used && source.isControlledBy(event.getPlayerId()) && ((RollDieEvent)event).getSides() == 6;
    }
}

