/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class TheCreationOfAvacynOneEffect
extends OneShotEffect {
    TheCreationOfAvacynOneEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for a card, exile it face down, then shuffle";
    }

    private TheCreationOfAvacynOneEffect(TheCreationOfAvacynOneEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheCreationOfAvacynOneEffect copy() {
        return new TheCreationOfAvacynOneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        if (controller.searchLibrary(target, source, game) && (card = controller.getLibrary().getCard(target.getFirstTarget(), game)) != null) {
            card.setFaceDown(true, game);
            UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source, (int)1);
            MageObject sourceObject = source.getSourceObject(game);
            String exileName = sourceObject != null ? sourceObject.getName() : "";
            controller.moveCardsToExile(card, source, game, false, exileId, exileName);
            card.setFaceDown(true, game);
            controller.shuffleLibrary(source, game);
        }
        return true;
    }
}

