/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TheCreationOfAvacynThreeEffect
extends OneShotEffect {
    TheCreationOfAvacynThreeEffect() {
        super(Outcome.Neutral);
        this.staticText = "You may put the exiled card onto the battlefield if it's a creature card. If you don't put it onto the battlefield, put it into its owner's hand.";
    }

    private TheCreationOfAvacynThreeEffect(TheCreationOfAvacynThreeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheCreationOfAvacynThreeEffect copy() {
        return new TheCreationOfAvacynThreeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        boolean creatureCard = false;
        for (Card card : exileZone.getCards(game)) {
            creatureCard |= card.isCreature(game);
        }
        if (creatureCard && controller.chooseUse(Outcome.PutCreatureInPlay, "Put the permanent in play?", source, game)) {
            controller.moveCards((Cards)exileZone, Zone.BATTLEFIELD, source, game);
            game.processAction();
        }
        controller.moveCards((Cards)exileZone, Zone.HAND, source, game);
        return true;
    }
}

