/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class TheCreationOfAvacynTwoEffect
extends OneShotEffect {
    TheCreationOfAvacynTwoEffect() {
        super(Outcome.Neutral);
        this.staticText = "Turn the exiled card face up. If it's a creature card, you lose life equal to its mana value";
    }

    private TheCreationOfAvacynTwoEffect(TheCreationOfAvacynTwoEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheCreationOfAvacynTwoEffect copy() {
        return new TheCreationOfAvacynTwoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        boolean creatureCard = false;
        int mv = 0;
        for (Card card : exileZone.getCards(game)) {
            card.setFaceDown(false, game);
            creatureCard |= card.isCreature(game);
            mv += card.getManaValue();
        }
        if (creatureCard) {
            new LoseLifeSourceControllerEffect(mv).apply(game, source);
        }
        return true;
    }
}

