/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;
import mage.util.CardUtil;

class TheDarknessCrystalExileEffect
extends ReplacementEffectImpl {
    TheDarknessCrystalExileEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if a nontoken creature an opponent controls would die, instead exile it and you gain 2 life";
    }

    private TheDarknessCrystalExileEffect(TheDarknessCrystalExileEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TheDarknessCrystalExileEffect copy() {
        return new TheDarknessCrystalExileEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = Optional.ofNullable(event).map(ZoneChangeEvent.class::cast).map(ZoneChangeEvent::getTarget).map(Card.class::cast).orElseGet(() -> game.getCard(event.getTargetId()));
        if (player == null || card == null) {
            return false;
        }
        player.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)game.getState().getZoneChangeCounter(source.getSourceId())), CardUtil.getSourceName((Game)game, (Ability)source));
        player.gainLife(2, game, source);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && zEvent.getTarget().isCreature(game) && game.getOpponents(source.getControllerId()).contains(zEvent.getTarget().getControllerId());
    }
}

