/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TheDayOfTheDoctorChooseEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.DOCTOR, "Doctors");

    TheDayOfTheDoctorChooseEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to three Doctors. You may exile all other creatures. If you do, {this} deals 13 damage to you";
    }

    private TheDayOfTheDoctorChooseEffect(TheDayOfTheDoctorChooseEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheDayOfTheDoctorChooseEffect copy() {
        return new TheDayOfTheDoctorChooseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 3, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        if (!player.chooseUse(this.outcome, "Exile all other creatures?", source, game)) {
            return false;
        }
        player.moveCards(game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game).stream().filter(permanent -> !target.getTargets().contains(permanent.getId())).collect(Collectors.toSet()), Zone.EXILED, source, game);
        player.damage(13, source, game);
        return true;
    }
}

