/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TheDayOfTheDoctorExileEffect
extends OneShotEffect {
    TheDayOfTheDoctorExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards from the top of your library until you exile a legendary card. You may play that card for as long as {this} remains on the battlefield. Put the rest of those exiled cards on the bottom of your library in a random order";
    }

    private TheDayOfTheDoctorExileEffect(TheDayOfTheDoctorExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheDayOfTheDoctorExileEffect copy() {
        return new TheDayOfTheDoctorExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card card = TheDayOfTheDoctorExileEffect.getCard(player, (Cards)cards, source, game);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilSourceLeavesBattlefield, (boolean)false);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    private static Card getCard(Player player, Cards cards, Ability source, Game game) {
        for (Card card : player.getLibrary().getCards(game)) {
            player.moveCards(card, Zone.EXILED, source, game);
            if (card.isLegendary(game)) {
                return card;
            }
            cards.add(card);
        }
        return null;
    }
}

