/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class TheDeathOfGwenStacyEffect
extends OneShotEffect {
    TheDeathOfGwenStacyEffect() {
        super(Outcome.Neutral);
        this.staticText = "each player may discard a card. Each player who doesn't loses 3 life";
    }

    private TheDeathOfGwenStacyEffect(TheDeathOfGwenStacyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheDeathOfGwenStacyEffect copy() {
        return new TheDeathOfGwenStacyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        HashMap<UUID, CardsImpl> cardsToDiscard = new HashMap<UUID, CardsImpl>();
        PlayerList playersInRange = game.getState().getPlayersInRange(controller.getId(), game);
        for (UUID playerId : playersInRange) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            Target target = new TargetDiscard(0, 1, new FilterCard(), playerId).withChooseHint("Choose a card to discard or lose 3 life");
            player.chooseTarget(this.outcome, target, source, game);
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            cardsToDiscard.put(playerId, cards);
        }
        for (UUID playerId : playersInRange) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            Cards cardsPlayer = (Cards)cardsToDiscard.get(playerId);
            if (cardsPlayer != null && !cardsPlayer.isEmpty()) {
                for (UUID cardId : cardsPlayer) {
                    Card card = game.getCard(cardId);
                    player.discard(card, false, source, game);
                }
                continue;
            }
            player.loseLife(3, game, source, false);
        }
        return true;
    }
}

