/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.ReturnFromGraveyardAtRandomEffect;
import mage.abilities.effects.common.RollDieWithResultTableEffect;
import mage.cards.t.TheDeckOfManyThingsReturnEffect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TheDeckOfManyThingsEffect
extends RollDieWithResultTableEffect {
    TheDeckOfManyThingsEffect() {
        super(20, "roll a d20 and subtract the number of cards in your hand. If the result is 0 or less, discard your hand");
        this.addTableEntry(1, 9, new Effect[]{new ReturnFromGraveyardAtRandomEffect(StaticFilters.FILTER_CARD, Zone.HAND)});
        this.addTableEntry(10, 19, new Effect[]{new DrawCardSourceControllerEffect(2)});
        this.addTableEntry(20, 20, new Effect[]{new TheDeckOfManyThingsReturnEffect()});
    }

    private TheDeckOfManyThingsEffect(TheDeckOfManyThingsEffect effect) {
        super((RollDieWithResultTableEffect)effect);
    }

    public TheDeckOfManyThingsEffect copy() {
        return new TheDeckOfManyThingsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, this.sides) - player.getHand().size();
        if (result <= 0) {
            player.discard(player.getHand(), false, source, game);
        }
        this.applyResult(result, game, source);
        return true;
    }
}

