/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.t.TheDeckOfManyThingsDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.util.CardUtil;

class TheDeckOfManyThingsReturnEffect
extends OneShotEffect {
    TheDeckOfManyThingsReturnEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "put a creature card from any graveyard onto the battlefield under your control. When that creature dies, its owner loses the game";
    }

    private TheDeckOfManyThingsReturnEffect(TheDeckOfManyThingsReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheDeckOfManyThingsReturnEffect copy() {
        return new TheDeckOfManyThingsReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new TheDeckOfManyThingsDelayedTriggeredAbility(permanent, game), source);
        return true;
    }
}

