/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPlaneswalkerPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TheElderspellEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPlaneswalkerPermanent();

    TheElderspellEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy any number of target planeswalkers. Choose a planeswalker you control. Put two loyalty counters on it for each planeswalker destroyed this way.";
    }

    private TheElderspellEffect(TheElderspellEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheElderspellEffect copy() {
        return new TheElderspellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int count = 0;
        for (UUID permId : ((Target)source.getTargets().get(0)).getTargets()) {
            Permanent permanent = game.getPermanent(permId);
            if (permanent == null || !permanent.destroy(source, game, false)) continue;
            ++count;
        }
        TargetPermanent targetPermanent = new TargetPermanent(filter);
        if (!player.choose(this.outcome, (Target)targetPermanent, source, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(targetPermanent.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        return permanent.addCounters(CounterType.LOYALTY.createInstance(2 * count), source.getControllerId(), source, game);
    }
}

