/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class TheEleventhDoctorEffect
extends OneShotEffect {
    TheEleventhDoctorEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile a card from your hand with a number of time counters on it equal to its mana value. If it doesn't have suspend, it gains suspend";
    }

    private TheEleventhDoctorEffect(TheEleventhDoctorEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheEleventhDoctorEffect copy() {
        return new TheEleventhDoctorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, StaticFilters.FILTER_CARD);
        player.choose(Outcome.PlayForFree, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        SuspendAbility.addTimeCountersAndSuspend((Card)card, (int)card.getManaValue(), (Ability)source, (Game)game);
        return true;
    }
}

