/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.AbilityImpl;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class TheFaceOfBoeEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("card with suspend");

    TheFaceOfBoeEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast a spell with suspend from your hand. If you do, pay its suspend cost rather than its mana cost";
    }

    private TheFaceOfBoeEffect(TheFaceOfBoeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheFaceOfBoeEffect copy() {
        return new TheFaceOfBoeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, filter);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        ManaCostsImpl cost = new ManaCostsImpl();
        CardUtil.castStream((Collection)card.getAbilities(game), SuspendAbility.class).map(AbilityImpl::getManaCosts).forEach(arg_0 -> cost.addAll(arg_0));
        CardUtil.castSingle((Player)player, (Ability)source, (Game)game, (Card)card, (ManaCostsImpl)cost);
        return true;
    }

    static {
        filter.add((Predicate)new AbilityPredicate(SuspendAbility.class));
    }
}

