/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.TheFallenWatcher;
import mage.constants.Outcome;
import mage.game.Game;

class TheFallenEffect
extends OneShotEffect {
    TheFallenEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 1 damage to each opponent and planeswalker it has dealt damage to this game";
    }

    private TheFallenEffect(TheFallenEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheFallenEffect copy() {
        return new TheFallenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TheFallenWatcher watcher = (TheFallenWatcher)game.getState().getWatcher(TheFallenWatcher.class);
        if (watcher != null && watcher.getPlayersAndWalkersDealtDamageThisGame(source.getSourceId()) != null) {
            for (UUID playerId : watcher.getPlayersAndWalkersDealtDamageThisGame(source.getSourceId())) {
                if (source.isControlledBy(playerId)) continue;
                game.damagePlayerOrPermanent(playerId, 1, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

