/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class TheFirstEruptionEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("a Mountain");

    TheFirstEruptionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Sacrifice a Mountain. If you do, {this} deals 3 damage to each creature";
    }

    private TheFirstEruptionEffect(TheFirstEruptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheFirstEruptionEffect copy() {
        return new TheFirstEruptionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)filter);
        boolean sacrificed = false;
        if (target.canChoose(controller.getId(), source, game)) {
            while (controller.canRespond() && !target.isChosen(game) && target.canChoose(controller.getId(), source, game)) {
                controller.choose(Outcome.Sacrifice, (Target)target, source, game);
            }
            for (int idx = 0; idx < target.getTargets().size(); ++idx) {
                Permanent permanent = game.getPermanent((UUID)target.getTargets().get(idx));
                if (permanent == null) continue;
                sacrificed |= permanent.sacrifice(source, game);
            }
        }
        if (sacrificed) {
            return new DamageAllEffect(3, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE).apply(game, source);
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.MOUNTAIN.getPredicate());
    }
}

