/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.t.TheFirstTyrannicWarReplacementEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TheFirstTyrannicWarFirstEffect
extends OneShotEffect {
    TheFirstTyrannicWarFirstEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a creature card from your hand onto the battlefield. If its mana cost contains {X}, it enters with a number of +1/+1 counters on it equal to the number of lands you control";
    }

    private TheFirstTyrannicWarFirstEffect(TheFirstTyrannicWarFirstEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheFirstTyrannicWarFirstEffect copy() {
        return new TheFirstTyrannicWarFirstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        if (card.getManaCostSymbols().stream().anyMatch(s -> s.contains("{X}"))) {
            game.addEffect(new TheFirstTyrannicWarReplacementEffect().setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        }
        return player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

