/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.common.GreatestAmongPermanentsValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class TheGreatHengeCostReductionEffect
extends CostModificationEffectImpl {
    TheGreatHengeCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "This spell costs {X} less to cast, where X is the greatest power among creatures you control";
    }

    private TheGreatHengeCostReductionEffect(TheGreatHengeCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int reductionAmount = GreatestAmongPermanentsValue.POWER_CONTROLLED_CREATURES.calculate(game, abilityToModify, (Effect)this);
        CardUtil.reduceCost((Ability)abilityToModify, (int)Math.max(0, reductionAmount));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId()) && game.getCard(abilityToModify.getSourceId()) != null;
    }

    public TheGreatHengeCostReductionEffect copy() {
        return new TheGreatHengeCostReductionEffect(this);
    }
}

