/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EscapeAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class TheGrimCaptainsLockerEffect
extends ContinuousEffectImpl {
    TheGrimCaptainsLockerEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Until end of turn, each creature card in your graveyard gains \"Escape &mdash; {3}{B}, Exile four other cards from your graveyard.\"";
    }

    private TheGrimCaptainsLockerEffect(TheGrimCaptainsLockerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TheGrimCaptainsLockerEffect copy() {
        return new TheGrimCaptainsLockerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.getGraveyard().getCards(game).stream().filter(Objects::nonNull).filter(card -> card.isCreature(game)).forEach(card -> {
            EscapeAbility ability = new EscapeAbility(card, "{3}{B}", 4);
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        });
        return true;
    }
}

