/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TheImmortalSunCantActivateEffect
extends ContinuousRuleModifyingEffectImpl {
    TheImmortalSunCantActivateEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Players can't activate planeswalkers' loyalty abilities";
    }

    private TheImmortalSunCantActivateEffect(TheImmortalSunCantActivateEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public TheImmortalSunCantActivateEffect copy() {
        return new TheImmortalSunCantActivateEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't activate loyalty abilities of planeswalkers (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (permanent == null) {
            return false;
        }
        if (permanent.isPlaneswalker(game)) {
            Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
            return ability.isPresent() && ability.get() instanceof LoyaltyAbility;
        }
        return false;
    }
}

