/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;

class TheIndomitableCastEffect
extends AsThoughEffectImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("three or more tapped pirates and/or vehicles");

    TheIndomitableCastEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast {this} from your graveyard as long as you control three or more tapped Pirates and/or Vehicles.";
    }

    private TheIndomitableCastEffect(TheIndomitableCastEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public TheIndomitableCastEffect copy() {
        return new TheIndomitableCastEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Card card;
        return sourceId.equals(source.getSourceId()) && (card = game.getCard(source.getSourceId())) != null && card.isOwnedBy(affectedControllerId) && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD && game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) >= 3;
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
        filter.add(Predicates.or((Predicate)SubType.PIRATE.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
    }
}

