/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheIrencragBecomesContinuousEffect
extends ContinuousEffectImpl {
    TheIrencragBecomesContinuousEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "{this} become a legendary Equipment artifact named Everflame, Heroes' Legacy. If you do, it gains equip {3} and \"Equipped creature gets +3/+3\" and loses all other abilities";
        this.dependencyTypes.add(DependencyType.ArtifactAddingRemoving);
    }

    protected TheIrencragBecomesContinuousEffect(TheIrencragBecomesContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TheIrencragBecomesContinuousEffect copy() {
        return new TheIrencragBecomesContinuousEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game));
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TextChangingEffects_3: {
                permanent.setName("Everflame, Heroes' Legacy");
                return true;
            }
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.addSuperType(game, SuperType.LEGENDARY);
                permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
                permanent.retainAllArtifactSubTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.EQUIPMENT});
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.removeAllAbilities(source.getSourceId(), game);
                permanent.addAbility((Ability)new EquipAbility(3, false), source.getSourceId(), game);
                permanent.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostEquippedEffect(3, 3)), source.getSourceId(), game);
                return true;
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TextChangingEffects_3 || layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

