/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class TheKenrithsRoyalFuneralCostEffect
extends CostModificationEffectImpl {
    TheKenrithsRoyalFuneralCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "legendary spells you cast cost {1} less to cast for each card exiled with {this}";
    }

    private TheKenrithsRoyalFuneralCostEffect(TheKenrithsRoyalFuneralCostEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        ExileZone exileZone = game.getState().getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)game.getState().getZoneChangeCounter(source.getSourceId())));
        if (exileZone == null) {
            return false;
        }
        int amount = exileZone.size();
        CardUtil.reduceCost((Ability)((SpellAbility)abilityToModify), (int)amount);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility) || !abilityToModify.isControlledBy(source.getControllerId())) {
            return false;
        }
        if (!game.inCheckPlayableState()) {
            Spell spell = game.getSpell(abilityToModify.getId());
            return spell != null && spell.isLegendary(game);
        }
        Card sourceCard = game.getCard(abilityToModify.getSourceId());
        return sourceCard != null && sourceCard.isLegendary(game);
    }

    public TheKenrithsRoyalFuneralCostEffect copy() {
        return new TheKenrithsRoyalFuneralCostEffect(this);
    }
}

