/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class TheLadyOfOtariaWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    TheLadyOfOtariaWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && zEvent.getTarget() != null && zEvent.getTarget().isLand(game) && zEvent.getTarget().isOwnedBy(zEvent.getTarget().getControllerId())) {
            this.playerSet.add(zEvent.getTarget().getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    static boolean checkPlayer(Ability source, Game game) {
        return ((TheLadyOfOtariaWatcher)game.getState().getWatcher(TheLadyOfOtariaWatcher.class)).playerSet.contains(source.getControllerId());
    }
}

