/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheMasterTranscendentContinuousEffect
extends ContinuousEffectImpl {
    TheMasterTranscendentContinuousEffect() {
        super(Duration.Custom, Outcome.Neutral);
        this.staticText = "It's a green Mutant with base power and toughness 3/3";
        this.addDependencyType(DependencyType.AddingCreatureType);
    }

    protected TheMasterTranscendentContinuousEffect(TheMasterTranscendentContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TheMasterTranscendentContinuousEffect copy() {
        return new TheMasterTranscendentContinuousEffect(this);
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.ColorChangingEffects_5 || layer == Layer.PTChangingEffects_7;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent creature;
        if (source.getTargets().getFirstTarget() == null) {
            creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        } else {
            creature = game.getPermanent(source.getTargets().getFirstTarget());
            if (creature == null) {
                creature = game.getPermanentEntering(source.getTargets().getFirstTarget());
            }
        }
        if (creature == null) {
            this.used = true;
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                creature.removeAllCreatureTypes(game);
                creature.addSubType(game, new SubType[]{SubType.MUTANT});
                break;
            }
            case ColorChangingEffects_5: {
                creature.getColor(game).setColor(ObjectColor.GREEN);
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                creature.getPower().setModifiedBaseValue(3);
                creature.getToughness().setModifiedBaseValue(3);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }
}

