/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.StateTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TheMillenniumCalendarStateTriggeredAbility
extends StateTriggeredAbility {
    TheMillenniumCalendarStateTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SacrificeSourceEffect());
        this.withRuleTextReplacement(true);
        this.addEffect((Effect)new LoseLifeOpponentsEffect(1000).setText("and each opponent loses 1,000 life"));
        this.setTriggerPhrase("When there are 1,000 or more time counters on {this}, ");
    }

    private TheMillenniumCalendarStateTriggeredAbility(TheMillenniumCalendarStateTriggeredAbility ability) {
        super((StateTriggeredAbility)ability);
    }

    public TheMillenniumCalendarStateTriggeredAbility copy() {
        return new TheMillenniumCalendarStateTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(this.getSourceId());
        return permanent != null && permanent.getCounters(game).getCount(CounterType.TIME) >= 1000;
    }
}

