/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CardsInAllGraveyardsCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class TheMimeoplasmEffect
extends OneShotEffect {
    TheMimeoplasmEffect() {
        super(Outcome.Copy);
    }

    private TheMimeoplasmEffect(TheMimeoplasmEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheMimeoplasmEffect copy() {
        return new TheMimeoplasmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (controller != null && permanent != null) {
            if (new CardsInAllGraveyardsCount((FilterCard)StaticFilters.FILTER_CARD_CREATURE).calculate(game, source, (Effect)this) >= 2 && controller.chooseUse(Outcome.Benefit, "Do you want to exile two creature cards from graveyards?", source, game)) {
                Card cardToCopy;
                TargetCardInGraveyard targetCopy = new TargetCardInGraveyard((FilterCard)new FilterCreatureCard("creature card to become a copy of"));
                targetCopy.withNotTarget(true);
                if (controller.choose(Outcome.Copy, (Target)targetCopy, source, game) && (cardToCopy = game.getCard(targetCopy.getFirstTarget())) != null) {
                    Card cardForCounters;
                    FilterCreatureCard filter = new FilterCreatureCard("creature card to determine amount of additional +1/+1 counters");
                    filter.add(Predicates.not((Predicate)new CardIdPredicate(cardToCopy.getId())));
                    TargetCardInGraveyard targetCounters = new TargetCardInGraveyard((FilterCard)filter);
                    targetCounters.withNotTarget(true);
                    if (controller.choose(Outcome.Copy, (Target)targetCounters, source, game) && (cardForCounters = game.getCard(targetCounters.getFirstTarget())) != null) {
                        CardsImpl cardsToExile = new CardsImpl();
                        cardsToExile.add(cardToCopy);
                        cardsToExile.add(cardForCounters);
                        controller.moveCards((Cards)cardsToExile, Zone.EXILED, source, game);
                        CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)cardToCopy, source.getSourceId());
                        game.addEffect((ContinuousEffect)copyEffect, source);
                        permanent.addCounters(CounterType.P1P1.createInstance(cardForCounters.getPower().getValue()), source.getControllerId(), source, game);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

