/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheOzolithMoveCountersEffect
extends OneShotEffect {
    TheOzolithMoveCountersEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may move all counters from {this} onto target creature";
    }

    private TheOzolithMoveCountersEffect(TheOzolithMoveCountersEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheOzolithMoveCountersEffect copy() {
        return new TheOzolithMoveCountersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (permanent == null || creature == null) {
            return false;
        }
        permanent.getCounters(game).copy().values().stream().filter(counter -> creature.addCounters(counter, source.getControllerId(), source, game)).forEach(counter -> permanent.removeCounters(counter, source, game));
        return true;
    }
}

