/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.LookAtTargetPlayerHandEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForOnePlayerEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TheRavensWarningTriggeredAbility
extends DelayedTriggeredAbility
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    TheRavensWarningTriggeredAbility() {
        super((Effect)new LookAtTargetPlayerHandEffect(), Duration.EndOfTurn, false);
        this.addEffect((Effect)new DrawCardSourceControllerEffect(1));
    }

    private TheRavensWarningTriggeredAbility(TheRavensWarningTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public TheRavensWarningTriggeredAbility copy() {
        return new TheRavensWarningTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER;
    }

    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!event.isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId()) && permanent.hasAbility((Ability)FlyingAbility.getInstance(), game);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.getFilteredEvents((BatchEvent)((DamagedBatchForOnePlayerEvent)event), game).isEmpty()) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
        return true;
    }

    public String getRule() {
        return "Whenever one or more creatures you control with flying deal combat damage to a player this turn, look at that player's hand and draw a card.";
    }
}

