/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.DamagedBatchBySourceEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TheRedTerrorTrigger
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedEvent> {
    public TheRedTerrorTrigger() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(1)));
        this.setTriggerPhrase("Whenever a red source you control deals damage to one or more permanents and/or players");
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_BY_SOURCE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent sourceObject;
        DamagedBatchBySourceEvent batchBySourceEvent = (DamagedBatchBySourceEvent)event;
        UUID sourceController = null;
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(batchBySourceEvent.getSourceId());
        if (sourcePermanent == null) {
            sourceObject = game.getObject(event.getSourceId());
            if (sourceObject instanceof Controllable) {
                sourceController = ((Controllable)sourceObject).getControllerId();
            }
        } else {
            sourceObject = sourcePermanent;
            sourceController = sourcePermanent.getControllerId();
        }
        return sourceObject.getColor(game).isRed() && this.getControllerId().equals(sourceController) && batchBySourceEvent.getAmount() > 0;
    }

    private TheRedTerrorTrigger(TheRedTerrorTrigger trigger) {
        super((TriggeredAbilityImpl)trigger);
    }

    public TheRedTerrorTrigger copy() {
        return new TheRedTerrorTrigger(this);
    }
}

