/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TheRevelationsOfEzioTriggeredAbility
extends DelayedTriggeredAbility {
    TheRevelationsOfEzioTriggeredAbility() {
        super((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), Duration.EndOfTurn, false);
    }

    private TheRevelationsOfEzioTriggeredAbility(TheRevelationsOfEzioTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public TheRevelationsOfEzioTriggeredAbility copy() {
        return new TheRevelationsOfEzioTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent != null && permanent.isControlledBy(this.getControllerId()) && permanent.hasSubtype(SubType.ASSASSIN, game)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an Assassin you control attacks this turn, put a +1/+1 counter on it.";
    }
}

