/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TheRingGoesSouthEffect
extends OneShotEffect {
    TheRingGoesSouthEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then reveal cards from the top of your library until you reveal X land cards, where X is the number of legendary creatures you control. Put those land cards onto the battlefield tapped and the rest on the bottom of your library in a random order.";
    }

    private TheRingGoesSouthEffect(TheRingGoesSouthEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheRingGoesSouthEffect copy() {
        return new TheRingGoesSouthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int count = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_LEGENDARY, source.getControllerId(), source, game);
        if (player == null || count < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        CardsImpl lands = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (card.isLand(game)) {
                lands.add(card);
            }
            if (lands.size() < count) continue;
            break;
        }
        player.revealCards(source, (Cards)cards, game);
        player.moveCards(lands.getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

