/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.t.TheRuinousPowersTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;
import mage.util.RandomUtil;

class TheRuinousPowersEffect
extends OneShotEffect {
    TheRuinousPowersEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose an opponent at random. Exile the top card of that player's library. Until end of turn, you may play that card and you may spend mana as though it were mana of any color to cast it. When you cast a spell this way, its owner loses life equal to its mana value.";
    }

    private TheRuinousPowersEffect(TheRuinousPowersEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheRuinousPowersEffect copy() {
        return new TheRuinousPowersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ArrayList opponents = new ArrayList(game.getOpponents(source.getControllerId()));
        if (opponents.isEmpty()) {
            return false;
        }
        Player opponent = game.getPlayer((UUID)opponents.get(RandomUtil.nextInt((int)opponents.size())));
        if (opponent == null) {
            return false;
        }
        Card card = opponent.getLibrary().getFromTop(game);
        player.moveCards(card, Zone.EXILED, source, game);
        if (card != null) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)true);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new TheRuinousPowersTriggeredAbility(card.getId()), source);
        }
        return true;
    }
}

