/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Objects;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TheTaleOfTamiyoEffect2
extends OneShotEffect {
    TheTaleOfTamiyoEffect2() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile any number of target instant, sorcery, and/or Tamiyo planeswalker cards from your graveyard. Copy them. You may cast any number of the copies.";
    }

    private TheTaleOfTamiyoEffect2(TheTaleOfTamiyoEffect2 effect) {
        super((OneShotEffect)effect);
    }

    public TheTaleOfTamiyoEffect2 copy() {
        return new TheTaleOfTamiyoEffect2(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        CardsImpl toExile = new CardsImpl();
        this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).forEach(arg_0 -> ((Cards)toExile).add(arg_0));
        if (controller == null || toExile.isEmpty()) {
            return false;
        }
        controller.moveCards((Cards)toExile, Zone.EXILED, source, game);
        toExile.retainZone(Zone.EXILED, game);
        for (Card card : toExile.getCards(game)) {
            if (!controller.chooseUse(this.outcome, "Cast copy of " + card.getName() + "?", source, game)) continue;
            Card cardCopy = game.copyCard(card, source, source.getControllerId());
            game.getState().setValue("PlayFromNotOwnHandZone" + cardCopy.getId(), (Object)Boolean.TRUE);
            controller.cast(controller.chooseAbilityForCast(cardCopy, game, false), game, false, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + cardCopy.getId(), null);
        }
        return true;
    }
}

