/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TheTenthDoctorEffect
extends OneShotEffect {
    TheTenthDoctorEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards from the top of your library until you exile a nonland card. Put three time counters on it. If it doesn't have suspend, it gains suspend";
    }

    private TheTenthDoctorEffect(TheTenthDoctorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (Card card : controller.getLibrary().getCards(game)) {
            controller.moveCards(card, Zone.EXILED, source, game);
            if (card.isLand(game)) continue;
            SuspendAbility.addTimeCountersAndSuspend((Card)card, (int)3, (Ability)source, (Game)game);
            return true;
        }
        return true;
    }

    public TheTenthDoctorEffect copy() {
        return new TheTenthDoctorEffect(this);
    }
}

