/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.common.counter.AddCounterEnteringCreatureEffect;
import mage.cards.Card;
import mage.cards.t.AddSubtypeEnteringCreatureEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class TheTombOfAclazotzWatcher
extends Watcher {
    private final Map<MageObjectReference, Map<UUID, Integer>> morMap = new HashMap<MageObjectReference, Map<UUID, Integer>>();
    private UUID playFromAnywhereEffectId;

    TheTombOfAclazotzWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell target;
        Card card;
        if (GameEvent.EventType.CAST_SPELL.equals((Object)event.getType()) && event.hasApprovingIdentifier(MageIdentifier.TheTombOfAclazotzWatcher) && (card = (target = game.getSpell(event.getTargetId())).getCard()) != null) {
            game.getState().addEffect((ContinuousEffect)new AddCounterEnteringCreatureEffect(new MageObjectReference((MageObject)target.getCard(), game), CounterType.FINALITY.createInstance(), Outcome.Neutral), (Ability)target.getSpellAbility());
            game.getState().addEffect((ContinuousEffect)new AddSubtypeEnteringCreatureEffect(new MageObjectReference((MageObject)target.getCard(), game), SubType.VAMPIRE, Outcome.Benefit), (Ability)card.getSpellAbility());
            UUID playEffectId = this.getPlayFromAnywhereEffect();
            if (playEffectId != null && ((AsThoughEffect)game.getContinuousEffects().getApplicableAsThoughEffects(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, game).listIterator().next()).getId().equals(playEffectId)) {
                ((AsThoughEffect)game.getContinuousEffects().getApplicableAsThoughEffects(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, game).listIterator().next()).discard();
            }
        }
    }

    boolean checkPermission(UUID playerId, Ability source, Game game) {
        if (!playerId.equals(source.getControllerId())) {
            return false;
        }
        MageObjectReference mor = new MageObjectReference(source.getSourceId(), source.getStackMomentSourceZCC(), game);
        return this.morMap.computeIfAbsent(mor, m -> new HashMap()).getOrDefault(playerId, 0) > 0;
    }

    void addPlayable(Ability source, Game game) {
        MageObjectReference mor = new MageObjectReference(source.getSourceId(), source.getStackMomentSourceZCC(), game);
        this.morMap.computeIfAbsent(mor, m -> new HashMap()).compute(source.getControllerId(), CardUtil::setOrIncrementValue);
    }

    void addPlayFromAnywhereEffect(UUID uuid) {
        this.playFromAnywhereEffectId = uuid;
    }

    UUID getPlayFromAnywhereEffect() {
        return this.playFromAnywhereEffectId;
    }

    public void reset() {
        this.morMap.clear();
        super.reset();
    }
}

