/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Arrays;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class TheWeddingOfRiverSongEffect
extends OneShotEffect {
    TheWeddingOfRiverSongEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then you may exile a nonland card from your hand with a number of time counters on it equal to its mana value. Then target opponent does the same. Cards exiled this way that don't have suspend gain suspend";
    }

    private TheWeddingOfRiverSongEffect(TheWeddingOfRiverSongEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheWeddingOfRiverSongEffect copy() {
        return new TheWeddingOfRiverSongEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Player player : Arrays.asList(game.getPlayer(source.getControllerId()), game.getPlayer(this.getTargetPointer().getFirst(game, source)))) {
            if (player == null || player.getHand().count((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game) < 1 || source.isControlledBy(player.getId()) && !player.chooseUse(this.outcome, "Suspend a nonland card from your hand?", source, game)) continue;
            TargetCardInHand target = new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
            player.choose(Outcome.PlayForFree, player.getHand(), (TargetCard)target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            if (card == null) continue;
            player.moveCards(card, Zone.EXILED, source, game);
            SuspendAbility.addTimeCountersAndSuspend((Card)card, (int)card.getManaValue(), (Ability)source, (Game)game);
        }
        return true;
    }
}

