/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ThelonsCurseEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("tapped blue creature");

    ThelonsCurseEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may choose any number of tapped blue creatures they control and pay {U} for each creature chosen this way. If the player does, untap those creatures.";
    }

    private ThelonsCurseEffect(ThelonsCurseEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThelonsCurseEffect copy() {
        return new ThelonsCurseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (player == null || sourcePermanent == null) {
            return false;
        }
        int countBattlefield = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, game.getActivePlayerId(), game).size();
        while (player.canRespond() && countBattlefield > 0 && player.chooseUse(Outcome.AIDontUseIt, "Pay {U} and untap a tapped blue creature under your control?", source, game)) {
            TargetPermanent tappedCreatureTarget = new TargetPermanent((FilterPermanent)filter);
            tappedCreatureTarget.withNotTarget(true);
            if (player.choose(Outcome.Detriment, (Target)tappedCreatureTarget, source, game)) {
                ManaCostsImpl cost = new ManaCostsImpl("{U}");
                Permanent tappedCreature = game.getPermanent(tappedCreatureTarget.getFirstTarget());
                if (cost.pay(source, game, source, player.getId(), false)) {
                    tappedCreature.untap(game);
                }
            }
            countBattlefield = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, game.getActivePlayerId(), game).size();
        }
        return true;
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
    }
}

